# -*- coding: utf-8 -*-
import matplotlib.pyplot as plt
import matplotlib.patches as patches
import numpy as np
from scipy.stats import nbinom
import random
import torch
import os

def is_valid_circle(ox, oy, r, circles):
    if r > 15:
        return False
    for x, y, radius in circles:
        if np.sqrt((ox - x) ** 2 + (oy - y) ** 2) < 1.5 * (r + radius):
            return False
    return True

def generate_circles(cx, cy, w, h, num_circles, target_success, p, proportionality_constant, dissq):
    circles = []
    success_count = 0
    attempts = 0

    while len(circles) < num_circles and attempts < 2000:

        distance = max(nbinom.rvs(target_success, p) , 10)  
        r = proportionality_constant * (distance**dissq)  
        theta = random.uniform(0, 2 * np.pi)
        ox = cx + distance * np.cos(theta)
        oy = cy + distance * np.sin(theta)

        if 0 <= ox + r <= w and 0 <= oy + r <= h and is_valid_circle(ox, oy, r, circles):
            circles.append((ox, oy, r))
            if distance <= 20:
                success_count += 1
        attempts += 1
        if attempts > 1000:
            break  
    return circles


def gen():
    num_map = 10
    circle_tensor1 = torch.zeros((10, 4, 3))
    circle_tensor2 = torch.zeros((10, 10, 3))
    for n in range(num_map):

        center_x, center_y = 50, 50
        width, height = 100, 100
        num_circles = 4
        target_success = 2
        success_prob = 0.2  
        dissq = 0.55
        proportionality_constant = 1.5 

        circles = generate_circles(center_x, center_y, width, height, num_circles, target_success, success_prob, proportionality_constant, dissq)
        for i in range(len(circles)):
            circle_tensor1[n][i][0] = circles[i][0]-50
            circle_tensor1[n][i][1] = circles[i][1]-50
            circle_tensor1[n][i][2] = circles[i][2]**2

    for n in range(num_map):
        center_x, center_y = 50, 50
        width, height = 100, 100
        num_circles = 10
        target_success = 2
        success_prob = 0.08  
        dissq = 0.45
        proportionality_constant = 1.5  

        circles = generate_circles(center_x, center_y, width, height, num_circles, target_success, success_prob, proportionality_constant, dissq)
        for i in range(len(circles)):
            circle_tensor2[n][i][0] = circles[i][0]-50
            circle_tensor2[n][i][1] = circles[i][1]-50
            circle_tensor2[n][i][2] = circles[i][2]**2


    directory_path = 'Parameter'
    if not os.path.exists(directory_path):
        os.makedirs(directory_path, exist_ok=True)
        torch.save((circle_tensor1,circle_tensor2), 'Parameter/circle.pt')

    fig, ax = plt.subplots()
    rect = patches.Rectangle((0, 0), width, height, linewidth=1, edgecolor='r', facecolor='none')
    ax.add_patch(rect)
    for (x, y, radius) in circles:
        circle = patches.Circle((x, y), radius, edgecolor='b', facecolor='none')
        ax.add_patch(circle)
    ax.plot(center_x, center_y, 'ro')
    ax.set_xlim(0, 100)
    ax.set_ylim(0, 100)
    ax.set_aspect('equal', adjustable='box')
    plt.grid(True)
